' PRIME SIEVE BENCHMARK

DEFINT A-Z  'only 16-bit integers - runs faster than DEFLNG A-Z

DECLARE FUNCTION sieve()

'Constants
CONST BATCH = 50
CONST BENCHTIME = 15

CONST TRUE = -1
CONST FALSE = NOT TRUE
CONST SIZE = 500

'Global Variables
DIM SHARED flags(SIZE)

PRINT "prime sieve benchmark ..."

cycles& = 0
t# = TIMER
WHILE TIMER < t# + BENCHTIME
    FOR b = 1 TO BATCH
	IF sieve <> 167 THEN
	    PRINT "whoops"
	END IF
    NEXT b
    cycles& = cycles& + BATCH
WEND
t# = TIMER - t#
PRINT USING "###.## sieves per second"; cycles& / t#

'Display results
PRINT "   2";
FOR b = 1 TO SIZE
    IF flags(b) THEN
	PRINT USING "####"; b*2+1;
    END IF
NEXT b

SYSTEM

FUNCTION sieve
    count = 0
    FOR f = 1 TO SIZE
	flags(f) = TRUE
    NEXT f
    FOR i = 1 TO SIZE
	IF flags(i) THEN
	    prime = i + i + 1
	    FOR k = i + prime TO SIZE STEP prime
		flags(k) = FALSE
	    NEXT k
	    count = count + 1
	END IF
    NEXT i
    sieve = count
END FUNCTION

